#!/bin/sh

OPT_COMMUNES="-Wall -ansi -g -D_POSIX_SOURCE -D_ATSU_EXTENSIONS"
OPTIONS="-Dconst= -DCALCULATEUR_ATSU $OPT_COMMUNES -I../INCLUDE"

if [ "$#" -ne 2 ]
then
    echo "Usage: $(basename $0) sourcedir destdir"
    exit 1
fi

if [ ! -d "$1" ]
then
    echo "$1 is not a directory"
    exit 1
fi

test -d $2 || mkdir $2

CURRDIR=`pwd`
cd $2
DESTDIR=`pwd`
cd $CURRDIR
cd $1

for filename in *.c
do
    echo $filename
    cpp $OPTIONS $filename > $DESTDIR/$filename
done
